package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;
import java.util.Map;

/**
 * 上下文对象
 */
public interface FlowContext {
    /**
     * 获取上下文数据,不存在时抛出异常
     */
    Object checkData(String key);

    /**
     * 获取上下文数据,不存在时抛出异常
     */
    <T> T checkData(String key, Class<T> clazz);

    /**
     * 获取上下文数据
     */
    Object getData(String key);

    /**
     * 获取上下文数据
     */
    <T> T getData(String key, Class<T> clazz);

    /**
     * 获取上下文数据
     */
    Object getData(String key, Object defaultValue);

    /**
     * 获取上下文数据
     */
    <T> T getData(String key, Class<T> clazz, T defaultValue);

    /**
     * 获取上下文数据
     */
    Map<String,Object> getData();

    /**
     * 获取临时数据key
     */
    Map<String, Object> getTemporaryDataMap();

    /**
     * 获取线程上下文数据
     */
    Object getThreadLocalData(String key);

    /**
     * 获取线程上下文数据
     */
    Object checkThreadLocalData(String key);

    /**
     * 获取线程上下文数据
     */
    Map<String, Object> getThreadLocalDataMap();

    /**
     * 获取请求数据key
     */
    Map<String, Object> getRequestDataMap();

    /**
     * 获取上下文中间数据
     */
    Map<String, Object> getContextDataMap();

    /**
     * 设置上下文数据
     */
    void putData(String key, Object value);

    /**
     * 设置上下文数据
     */
    void putData(Map<String, Object> map);

    /**
     * 设置临时数据
     */
    void putTemporaryData(String key, Object value);

    /**
     * 设置临时数据
     */
    void putTemporaryData(Map<String, Object> map);

    /**
     * 设置线程本地数据
     */
    void putThreadLocalData(String key, Object value);

    /**
     * 设置线程本地数据
     */
    void putThreadLocalData(Map<String, Object> map);

    /**
     * 移除上下文数据
     */
    void removeData(String key);

    /**
     * 流程备注
     */
    void remark(String remark);

    /**
     * 中断当前流程
     * @param reason 中断原因
     */
    void brokenCurrentFlow(String reason);

    /**
     * 中断流程
     * @param reason 中断原因
     */
    void broken(String reason);

    /**
     * 获取主流程名
     */
    String getFlowName();

    /**
     * 获取当前子流程名
     */
    String getCurrentSubFlowName();

    /**
     * 获取流程列表
     */
    List<String> getFlowNameList();

    /**
     * 获取流程日志
     */
    String getFlowTrace();

    /**
     * 获取流程异常
     */
    Exception getFlowException();

    /**
     * 获取流程中断原因
     */
    String getBrokenReason();

    /**
     * 开启子流程
     */
    QuickFlowExecutor startSubFlow(String name);

    /**
     * 获取流程
     */
    BusinessFlow getBusinessFlow(String flowName);
}
