package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.exception.BrokenCurrentFlowException;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.*;

public class FlowContextImpl implements FlowContext {
    /**
     * 配置数据
     */
    private FlowExecutorConfig flowExecutorConfig;

    public FlowContextImpl(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    @Override
    public Object checkData(String key) {
        Object value = getData(key);
        if(null==value){
            throw new IllegalArgumentException("上下文数据中key为"+key+"的值不能为空!");
        }
        if(value instanceof Collection){
            if(((Collection)value).isEmpty()){
                throw new IllegalArgumentException("上下文数据中key为"+key+"的列表不能为空!");
            }
        }
        return value;
    }

    @Override
    public <T> T checkData(String key, Class<T> clazz) {
        T value = getData(key, clazz);
        if(null==value){
            throw new IllegalArgumentException("上下文数据中key为"+key+"的值不能为空!");
        }
        if(value instanceof Collection){
            if(((Collection)value).isEmpty()){
                throw new IllegalArgumentException("上下文数据中key为"+key+"的列表不能为空!");
            }
        }
        return value;
    }

    @Override
    public Object getData(String key) {
        Object value = flowExecutorConfig.rootConfig.dataMap.get(key);
        return value;
    }

    @Override
    public <T> T getData(String key, Class<T> clazz) {
        Object value = getData(key);
        if(value instanceof JSONObject){
            JSONObject o = (JSONObject) value;
            return o.toJavaObject(clazz);
        }
        if(value instanceof JSONArray){
            JSONArray o = (JSONArray) value;
            return o.toJavaObject(clazz);
        }
        try {
            T t = clazz.cast(value);
            return t;
        }catch (Exception e){
            throw new UnsupportedOperationException("无法转换类型!预期类型:"+clazz.getName()+",实际类型:"+value.getClass().getName());
        }
    }

    @Override
    public Object getData(String key, Object defaultValue) {
        Object value = getData(key);
        if(null==value){
            return defaultValue;
        }else{
            return value;
        }
    }

    @Override
    public <T> T getData(String key, Class<T> clazz, T defaultValue) {
        T value = getData(key, clazz);
        if(null==value){
            return defaultValue;
        }else{
            return value;
        }
    }

    @Override
    public Map<String, Object> getData() {
        return flowExecutorConfig.rootConfig.dataMap;
    }

    @Override
    public void putData(String key, Object value) {
        if(null!=key&&null!=value){
            flowExecutorConfig.rootConfig.dataMap.put(key, value);
        }
    }

    @Override
    public void putData(Map<String, Object> map) {
        if(null!=map){
            Iterator<Map.Entry<String,Object>> iterator = map.entrySet().iterator();
            while(iterator.hasNext()){
                if(null==iterator.next().getValue()){
                    iterator.remove();
                }
            }
            flowExecutorConfig.rootConfig.dataMap.putAll(map);
        }
    }

    @Override
    public Map<String, Object> getTemporaryDataMap() {
        Map<String,Object> temporaryDataMap = new HashMap<>();
        for(String key:flowExecutorConfig.rootConfig.temporaryKeySet){
            temporaryDataMap.put(key, flowExecutorConfig.rootConfig.dataMap.get(key));
        }
        return temporaryDataMap;
    }

    @Override
    public Object getThreadLocalData(String key) {
        Map threadLocalMap = flowExecutorConfig.rootConfig.threadLocalDataMap.get();
        if(null==threadLocalMap){
            return null;
        }
        return threadLocalMap.get(key);
    }

    @Override
    public Object checkThreadLocalData(String key) {
        Object value = getThreadLocalData(key);
        if(null==value){
            throw new IllegalArgumentException("线程本地数据中key为"+key+"的值不能为空!");
        }
        if(value instanceof Collection){
            if(((Collection)value).isEmpty()){
                throw new IllegalArgumentException("线程本地数据中key为"+key+"的列表不能为空!");
            }
        }
        return value;
    }

    @Override
    public Map<String, Object> getThreadLocalDataMap() {
        Map threadLocalMap = flowExecutorConfig.rootConfig.threadLocalDataMap.get();
        return threadLocalMap;
    }

    @Override
    public Map<String, Object> getRequestDataMap() {
        Map<String,Object> requestDataMap = new HashMap<>();
        for(String key:flowExecutorConfig.rootConfig.requestKeySet){
            requestDataMap.put(key, flowExecutorConfig.rootConfig.dataMap.get(key));
        }
        return requestDataMap;
    }

    @Override
    public Map<String, Object> getContextDataMap() {
        Set<String> keySet = new HashSet<>(flowExecutorConfig.rootConfig.dataMap.keySet());
        keySet.removeAll(flowExecutorConfig.rootConfig.requestKeySet);
        keySet.removeAll(flowExecutorConfig.rootConfig.temporaryKeySet);
        Map<String,Object> contextDataMap = new HashMap<>();
        for(String key:keySet){
            contextDataMap.put(key, flowExecutorConfig.rootConfig.dataMap.get(key));
        }
        return contextDataMap;
    }

    @Override
    public void putTemporaryData(String key, Object value) {
        putData(key, value);
        if(null!=key){
            flowExecutorConfig.rootConfig.temporaryKeySet.add(key);
        }
    }

    @Override
    public void putTemporaryData(Map<String, Object> map) {
        putData(map);
        if(null!=map){
            flowExecutorConfig.rootConfig.temporaryKeySet.addAll(map.keySet());
        }
    }

    @Override
    public void putThreadLocalData(String key, Object value) {
        if(null!=key&&null!=value){
            Map<String, Object> threadLocalMap = flowExecutorConfig.rootConfig.threadLocalDataMap.get();
            if(null==threadLocalMap){
                threadLocalMap = new HashMap<>();
                flowExecutorConfig.rootConfig.threadLocalDataMap.set(threadLocalMap);
            }
            threadLocalMap.put(key, value);
        }
    }

    @Override
    public void putThreadLocalData(Map<String, Object> map) {
        if(null!=map){
            Map<String, Object> threadLocalMap = flowExecutorConfig.rootConfig.threadLocalDataMap.get();
            if(null==threadLocalMap){
                threadLocalMap = new HashMap<>();
                flowExecutorConfig.rootConfig.threadLocalDataMap.set(threadLocalMap);
            }
            threadLocalMap.putAll(map);
        }
    }

    @Override
    public void removeData(String key) {
        if(null!=key){
            flowExecutorConfig.rootConfig.dataMap.remove(key);
        }
    }

    @Override
    public void remark(String remark) {
        flowExecutorConfig.rootConfig.remarkBuilder.append("|"+remark);
    }

    @Override
    public void brokenCurrentFlow(String reason) {
        throw new BrokenCurrentFlowException(reason);
    }

    @Override
    public void broken(String reason) {
        throw new BrokenException(reason);
    }

    @Override
    public String getFlowName() {
        return flowExecutorConfig.name;
    }

    @Override
    public String getCurrentSubFlowName() {
        return null;
    }

    @Override
    public List<String> getFlowNameList() {
        return flowExecutorConfig.rootConfig.flowNameList;
    }

    @Override
    public String getFlowTrace() {
        return flowExecutorConfig.rootConfig.printTraceBuilder.toString();
    }

    @Override
    public Exception getFlowException() {
        return flowExecutorConfig.rootConfig.exception;
    }

    @Override
    public String getBrokenReason() {
        return flowExecutorConfig.rootConfig.brokenReason;
    }

    @Override
    public QuickFlowExecutor startSubFlow(String name) {
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        flowExecutorConfig.rootConfig = this.flowExecutorConfig.rootConfig;
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = new FlowContextImpl(flowExecutorConfig);
        flowExecutorConfig.subflowLevel = this.flowExecutorConfig.subflowLevel+1;
        flowExecutorConfig.parentFlowExecutorConfig = this.flowExecutorConfig;
        return new QuickFlowExecutor(flowExecutorConfig);
    }

    @Override
    public BusinessFlow getBusinessFlow(String flowName) {
        BusinessFlow businessFlow = flowExecutorConfig.rootConfig.flowConfig.businessMap.get(flowName);
        if(null==businessFlow){
            throw new IllegalArgumentException("流程实例不存在!请先调用save方法保存该流程!流程名称:"+flowName);
        }
        return businessFlow;
    }

}
