/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowConfig;
import cn.schoolwow.quickflow.domain.FlowContextImpl;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.domain.FlowExecutorOption;
import cn.schoolwow.quickflow.domain.FlowExecutorRootConfig;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.FlowNameInstanceMappingHandler;
import cn.schoolwow.quickflow.listener.QuickFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickFlow {
    private Logger logger = LoggerFactory.getLogger(QuickFlow.class);
    private static QuickFlow defaultQuickFlow = new QuickFlow();
    private FlowConfig flowConfig = new FlowConfig();

    public static QuickFlow newInstance() {
        return new QuickFlow();
    }

    public static QuickFlow defaultQuickFlow() {
        return defaultQuickFlow;
    }

    public QuickFlow flowListener(QuickFlowListener quickFlowListener) {
        this.flowConfig.quickFlowListener = quickFlowListener;
        return this;
    }

    public QuickFlow printTrace(boolean printTrace) {
        this.flowConfig.printTrace = printTrace;
        return this;
    }

    public QuickFlow printConsumeTime(boolean printConsumeTime) {
        this.flowConfig.printConsumeTime = printConsumeTime;
        return this;
    }

    public QuickFlow flowNameInstanceMappingHandler(FlowNameInstanceMappingHandler flowNameInstanceMappingHandler) {
        this.flowConfig.flowNameInstanceMappingHandler = flowNameInstanceMappingHandler;
        return this;
    }

    public QuickFlow tryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler) {
        this.flowConfig.tryCatchFinallyHandler = tryCatchFinallyHandler;
        return this;
    }

    public QuickFlowExecutor startFlow(String name) {
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u4e3b\u6d41\u7a0b\u540d\u79f0!");
        }
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        FlowExecutorRootConfig rootConfig = new FlowExecutorRootConfig();
        rootConfig.name = name;
        rootConfig.threadLocalDataMap.set(new HashMap());
        rootConfig.flowConfig = this.flowConfig;
        if (this.flowConfig.printTrace) {
            rootConfig.printTraceBuilder = new StringBuilder();
        }
        flowExecutorConfig.rootConfig = rootConfig;
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = new FlowContextImpl(flowExecutorConfig);
        return new QuickFlowExecutor(flowExecutorConfig);
    }

    public QuickFlowExecutor startFlow(FlowExecutorOption flowExecutorOption) {
        if (null == this.flowConfig.flowNameInstanceMappingHandler) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u6d41\u7a0b\u540d\u79f0\u5b9e\u4f8b\u6620\u5c04\u5904\u7406\u5668!");
        }
        if (null == flowExecutorOption.flowNameList || flowExecutorOption.flowNameList.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u6d41\u7a0b\u5217\u8868!");
        }
        QuickFlowExecutor quickFlowExecutor = this.startFlow(flowExecutorOption.name).putData(flowExecutorOption.requestData);
        for (String flowName : flowExecutorOption.flowNameList) {
            if (flowName.startsWith("handler:")) {
                TryCatchFinallyHandler tryCatchFinallyHandler = this.flowConfig.flowNameInstanceMappingHandler.getTryCatchFinallyByName(flowName.substring(8));
                quickFlowExecutor.tryCatchFinallyHandler(tryCatchFinallyHandler);
                continue;
            }
            if (this.flowConfig.businessMap.containsKey(flowName)) {
                quickFlowExecutor.next(this.flowConfig.businessMap.get(flowName));
                continue;
            }
            quickFlowExecutor.next(this.flowConfig.flowNameInstanceMappingHandler.getFlowByName(flowName));
        }
        return quickFlowExecutor;
    }

    public BusinessFlow getBusinessFlow(String flowName) {
        BusinessFlow businessFlow = this.flowConfig.businessMap.get(flowName);
        if (null == businessFlow) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728!\u8bf7\u5148\u8c03\u7528save\u65b9\u6cd5\u4fdd\u5b58\u8be5\u6d41\u7a0b!\u6d41\u7a0b\u540d\u79f0:" + flowName);
        }
        return businessFlow;
    }
}

