package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class FlowExecutorRootConfig {
    /**
     * 流程名称
     */
    public String name;

    /**
     * 流程备注记录
     */
    public StringBuilder remarkBuilder = new StringBuilder();

    /**
     * 上下文数据
     */
    public Map<String, Object> dataMap = new ConcurrentHashMap<>();

    /**
     * 线程本地数据
     */
    public ThreadLocal<Map<String, Object>> threadLocalDataMap = new ThreadLocal<>();

    /**
     * 临时数据key
     * */
    public Set<String> temporaryKeySet = new HashSet<>();

    /**
     * 请求数据
     * */
    public Set<String> requestKeySet = new HashSet<>();

    /**
     * 是否打印流程列表
     * */
    public boolean printTrace = true;

    /**
     * 打印执行路径
     */
    public StringBuilder printTraceBuilder;

    /**
     * 流程列表
     */
    public List<String> flowNameList = new ArrayList<>();

    /**
     * try-catch-finally事件处理
     */
    public TryCatchFinallyHandler tryCatchFinallyHandler;

    /**
     * 是否忽略异常
     * */
    public boolean ignoreException;

    /**
     * 流程异常
     * */
    public Exception exception;

    /**
     * 中断原因
     * */
    public String brokenReason;

    /**
     * 流程下标
     */
    public AtomicInteger index = new AtomicInteger(0);

    /**
     * 子流程层级计数
     * */
    public int subflowLevelCount = 0;

    /**
     * 全局流程配置
     * */
    public FlowConfig flowConfig;
}
