/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.exception.BrokenCurrentFlowException;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlowContextImpl
implements FlowContext {
    private FlowExecutorConfig flowExecutorConfig;

    public FlowContextImpl(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    @Override
    public Object checkData(String key) {
        Object value = this.getData(key);
        if (null == value) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return value;
    }

    @Override
    public <T> T checkData(String key, Class<T> clazz) {
        T value = this.getData(key, clazz);
        if (null == value) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4e0b\u6587\u6570\u636e\u4e2dkey\u4e3a" + key + "\u7684\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return value;
    }

    @Override
    public Object getData(String key) {
        Object value = this.flowExecutorConfig.dataMap.get(key);
        if (null == value) {
            value = this.flowExecutorConfig.threadLocalDataMap.get().get(key);
        }
        return value;
    }

    @Override
    public <T> T getData(String key, Class<T> clazz) {
        Object value = this.getData(key);
        if (value instanceof JSONObject) {
            JSONObject o = (JSONObject)value;
            return (T)o.toJavaObject(clazz);
        }
        if (value instanceof JSONArray) {
            JSONArray o = (JSONArray)value;
            return (T)o.toJavaObject(clazz);
        }
        try {
            T t = clazz.cast(value);
            return t;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("\u65e0\u6cd5\u8f6c\u6362\u7c7b\u578b!\u9884\u671f\u7c7b\u578b:" + clazz.getName() + ",\u5b9e\u9645\u7c7b\u578b:" + value.getClass().getName());
        }
    }

    @Override
    public Object getData(String key, Object defaultValue) {
        Object value = this.getData(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public <T> T getData(String key, Class<T> clazz, T defaultValue) {
        T value = this.getData(key, clazz);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Map<String, Object> getData() {
        return this.flowExecutorConfig.dataMap;
    }

    @Override
    public void putData(String key, Object value) {
        if (null != key && null != value) {
            this.flowExecutorConfig.dataMap.put(key, value);
        }
    }

    @Override
    public void putData(Map<String, Object> map) {
        if (null != map) {
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                if (null != iterator.next().getValue()) continue;
                iterator.remove();
            }
            this.flowExecutorConfig.dataMap.putAll(map);
        }
    }

    @Override
    public Map<String, Object> getTemporaryDataMap() {
        HashMap<String, Object> temporaryDataMap = new HashMap<String, Object>();
        for (String key : this.flowExecutorConfig.temporaryKeySet) {
            temporaryDataMap.put(key, this.flowExecutorConfig.dataMap.get(key));
        }
        return temporaryDataMap;
    }

    @Override
    public Map<String, Object> getRequestDataMap() {
        HashMap<String, Object> requestDataMap = new HashMap<String, Object>();
        for (String key : this.flowExecutorConfig.requestKeySet) {
            requestDataMap.put(key, this.flowExecutorConfig.dataMap.get(key));
        }
        return requestDataMap;
    }

    @Override
    public Map<String, Object> getContextDataMap() {
        HashSet<String> keySet = new HashSet<String>(this.flowExecutorConfig.dataMap.keySet());
        keySet.removeAll(this.flowExecutorConfig.requestKeySet);
        keySet.removeAll(this.flowExecutorConfig.temporaryKeySet);
        HashMap<String, Object> contextDataMap = new HashMap<String, Object>();
        for (String key : keySet) {
            contextDataMap.put(key, this.flowExecutorConfig.dataMap.get(key));
        }
        return contextDataMap;
    }

    @Override
    public void putTemporaryData(String key, Object value) {
        this.putData(key, value);
        if (null != key) {
            this.flowExecutorConfig.temporaryKeySet.add(key);
        }
    }

    @Override
    public void putTemporaryData(Map<String, Object> map) {
        this.putData(map);
        if (null != map) {
            this.flowExecutorConfig.temporaryKeySet.addAll(map.keySet());
        }
    }

    @Override
    public void putThreadLocalData(String key, Object value) {
        if (null != key && null != value) {
            this.flowExecutorConfig.threadLocalDataMap.get().put(key, value);
        }
    }

    @Override
    public void putThreadLocalData(Map<String, Object> map) {
        if (null != map) {
            this.flowExecutorConfig.threadLocalDataMap.get().putAll(map);
        }
    }

    @Override
    public void removeData(String key) {
        if (null != key) {
            this.flowExecutorConfig.dataMap.remove(key);
        }
    }

    @Override
    public void remark(String remark) {
        this.flowExecutorConfig.remarkBuilder.append("|" + remark);
    }

    @Override
    public void brokenCurrentFlow(String reason) {
        throw new BrokenCurrentFlowException(reason);
    }

    @Override
    public void broken(String reason) {
        throw new BrokenException(reason);
    }

    @Override
    public String getFlowName() {
        return this.flowExecutorConfig.name;
    }

    @Override
    public List<String> getFlowNameList() {
        return this.flowExecutorConfig.flowNameList;
    }

    @Override
    public String getFlowTrace() {
        return this.flowExecutorConfig.printTraceBuilder.toString();
    }

    @Override
    public Exception getFlowException() {
        return this.flowExecutorConfig.exception;
    }

    @Override
    public String getBrokenReason() {
        return this.flowExecutorConfig.brokenReason;
    }

    @Override
    public QuickFlowExecutor startSubFlow(String name) {
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = new FlowContextImpl(flowExecutorConfig);
        flowExecutorConfig.dataMap = this.flowExecutorConfig.dataMap;
        flowExecutorConfig.threadLocalDataMap.set(new HashMap());
        flowExecutorConfig.threadLocalDataMap.get().putAll(this.flowExecutorConfig.dataMap);
        flowExecutorConfig.index = this.flowExecutorConfig.index;
        flowExecutorConfig.subflowLevel = this.flowExecutorConfig.subflowLevel + 1;
        flowExecutorConfig.flowNameList = new ArrayList<String>();
        flowExecutorConfig.temporaryKeySet = this.flowExecutorConfig.temporaryKeySet;
        flowExecutorConfig.parentFlowExecutorConfig = this.flowExecutorConfig;
        flowExecutorConfig.flowConfig = this.flowExecutorConfig.flowConfig;
        flowExecutorConfig.printTrace = this.flowExecutorConfig.printTrace;
        if (flowExecutorConfig.flowConfig.printTrace) {
            flowExecutorConfig.printTraceBuilder = this.flowExecutorConfig.printTraceBuilder;
        }
        return new QuickFlowExecutor(flowExecutorConfig);
    }

    @Override
    public BusinessFlow getBusinessFlow(String flowName) {
        BusinessFlow businessFlow = this.flowExecutorConfig.flowConfig.businessMap.get(flowName);
        if (null == businessFlow) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728!\u8bf7\u5148\u8c03\u7528save\u65b9\u6cd5\u4fdd\u5b58\u8be5\u6d41\u7a0b!\u6d41\u7a0b\u540d\u79f0:" + flowName);
        }
        return businessFlow;
    }
}

