/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickflow;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.exception.BrokenCurrentFlowException;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickFlowExecutor {
    private Logger logger = LoggerFactory.getLogger(QuickFlowExecutor.class);
    private FlowExecutorConfig flowExecutorConfig;

    public QuickFlowExecutor(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    public QuickFlowExecutor putData(String key, Object value) {
        this.flowExecutorConfig.flowContext.putData(key, value);
        this.flowExecutorConfig.requestKeySet.add(key);
        return this;
    }

    public QuickFlowExecutor putData(Map<String, Object> dataMap) {
        this.flowExecutorConfig.flowContext.putData(dataMap);
        this.flowExecutorConfig.requestKeySet.addAll(dataMap.keySet());
        return this;
    }

    public QuickFlowExecutor putTemporaryData(String key, Object value) {
        this.flowExecutorConfig.flowContext.putTemporaryData(key, value);
        this.flowExecutorConfig.requestKeySet.add(key);
        return this;
    }

    public QuickFlowExecutor putTemporaryData(Map<String, Object> dataMap) {
        this.flowExecutorConfig.flowContext.putTemporaryData(dataMap);
        this.flowExecutorConfig.requestKeySet.addAll(dataMap.keySet());
        return this;
    }

    public QuickFlowExecutor putThreadLocalData(String key, Object value) {
        this.flowExecutorConfig.flowContext.putThreadLocalData(key, value);
        return this;
    }

    public QuickFlowExecutor putThreadLocalData(Map<String, Object> dataMap) {
        this.flowExecutorConfig.flowContext.putThreadLocalData(dataMap);
        return this;
    }

    public QuickFlowExecutor next(String flowName) {
        if (null == this.flowExecutorConfig.flowConfig.flowNameInstanceMappingHandler) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u6d41\u7a0b\u540d\u79f0\u5b9e\u4f8b\u6620\u5c04\u5904\u7406\u5668!");
        }
        BusinessFlow flow = this.flowExecutorConfig.flowConfig.flowNameInstanceMappingHandler.getFlowByName(flowName);
        this.flowExecutorConfig.flowList.add(flow);
        return this;
    }

    public QuickFlowExecutor next(BusinessFlow flow) {
        this.flowExecutorConfig.flowList.add(flow);
        return this;
    }

    public QuickFlowExecutor tryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler) {
        this.flowExecutorConfig.tryCatchFinallyHandler = tryCatchFinallyHandler;
        return this;
    }

    public QuickFlowExecutor printTrace(boolean printTrace) {
        this.flowExecutorConfig.printTrace = printTrace;
        return this;
    }

    public QuickFlowExecutor ignoreException(boolean ignoreException) {
        this.flowExecutorConfig.ignoreException = ignoreException;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowContext execute() throws Exception {
        block23: {
            this.printFlowTrace("|---" + this.flowExecutorConfig.name);
            if (null != this.flowExecutorConfig.tryCatchFinallyHandler) {
                this.flowExecutorConfig.flowNameList.add("handler:" + this.flowExecutorConfig.tryCatchFinallyHandler.name());
            }
            for (BusinessFlow businessFlow : this.flowExecutorConfig.flowList) {
                this.flowExecutorConfig.flowNameList.add(businessFlow.name());
            }
            BusinessFlow currentFlow = this.flowExecutorConfig.flowList.get(0);
            try {
                if (null != this.flowExecutorConfig.tryCatchFinallyHandler) {
                    this.flowExecutorConfig.tryCatchFinallyHandler.handleTry(this.flowExecutorConfig.flowContext);
                }
                if (null == this.flowExecutorConfig.parentFlowExecutorConfig && null != this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler) {
                    this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler.handleTry(this.flowExecutorConfig.flowContext);
                }
                Iterator<BusinessFlow> iterator = this.flowExecutorConfig.flowList.iterator();
                while (iterator.hasNext()) {
                    BusinessFlow flow2;
                    currentFlow = flow2 = iterator.next();
                    if (null != this.flowExecutorConfig.flowConfig.quickFlowListener) {
                        this.flowExecutorConfig.flowConfig.quickFlowListener.beforeExecuteFlow(flow2, this.flowExecutorConfig.flowContext);
                    }
                    try {
                        long startTime = System.currentTimeMillis();
                        flow2.executeBusinessFlow(this.flowExecutorConfig.flowContext);
                        long endTime = System.currentTimeMillis();
                        this.printFlowTrace("[" + this.flowExecutorConfig.index.getAndIncrement() + "]" + (this.flowExecutorConfig.flowConfig.printConsumeTime ? "|" + (endTime - startTime) + "\u6beb\u79d2|" : "") + flow2.name() + this.flowExecutorConfig.remarkBuilder.toString());
                        this.flowExecutorConfig.remarkBuilder.setLength(0);
                    }
                    catch (BrokenCurrentFlowException e) {
                        this.flowExecutorConfig.brokenReason = e.getReason();
                        this.printFlowTrace("[" + this.flowExecutorConfig.index.getAndIncrement() + "]|[x]|" + flow2.name() + "|\u5f53\u524d\u6d41\u7a0b\u4e2d\u65ad|\u4e2d\u65ad\u539f\u56e0:" + e.getReason() + this.flowExecutorConfig.remarkBuilder.toString());
                        this.flowExecutorConfig.remarkBuilder.setLength(0);
                    }
                    if (null == this.flowExecutorConfig.flowConfig.quickFlowListener) continue;
                    this.flowExecutorConfig.flowConfig.quickFlowListener.afterExecuteFlow(flow2, this.flowExecutorConfig.flowContext);
                }
            }
            catch (BrokenException brokenException) {
                if (null != this.flowExecutorConfig.parentFlowExecutorConfig && !this.flowExecutorConfig.ignoreException) {
                    throw brokenException;
                }
                this.printFlowTrace("[" + this.flowExecutorConfig.index.getAndIncrement() + "]|[x]|\u4e1a\u52a1\u6d41\u7a0b\u7ec8\u6b62|\u539f\u56e0:" + brokenException.getReason());
                this.flowExecutorConfig.brokenReason = brokenException.getReason();
                return this.flowExecutorConfig.brokenReason;
            }
            catch (Exception exception) {
                this.printFlowTrace("[" + this.flowExecutorConfig.index.getAndIncrement() + "]|[x]|" + currentFlow.name() + "|\u4e1a\u52a1\u6d41\u7a0b\u53d1\u751f\u5f02\u5e38|\u5f02\u5e38\u4fe1\u606f:" + exception.getClass().getName() + "-" + exception.getMessage());
                if (null != this.flowExecutorConfig.tryCatchFinallyHandler) {
                    this.flowExecutorConfig.tryCatchFinallyHandler.handleException(this.flowExecutorConfig.flowContext, exception);
                }
                if (null == this.flowExecutorConfig.parentFlowExecutorConfig && null != this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler) {
                    this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler.handleException(this.flowExecutorConfig.flowContext, exception);
                }
                if (null == this.flowExecutorConfig.parentFlowExecutorConfig) {
                    this.flowExecutorConfig.exception = exception;
                }
                if (!this.flowExecutorConfig.ignoreException) {
                    throw exception;
                }
                exception.printStackTrace();
            }
            finally {
                if (null != this.flowExecutorConfig.tryCatchFinallyHandler) {
                    this.flowExecutorConfig.tryCatchFinallyHandler.handleFinally(this.flowExecutorConfig.flowContext);
                }
                if (null == this.flowExecutorConfig.parentFlowExecutorConfig && null != this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler) {
                    this.flowExecutorConfig.flowConfig.tryCatchFinallyHandler.handleFinally(this.flowExecutorConfig.flowContext);
                }
                if (null != this.flowExecutorConfig.parentFlowExecutorConfig) break block23;
                Set<String> set = this.flowExecutorConfig.temporaryKeySet;
                for (String temporaryKey : set) {
                    this.flowExecutorConfig.dataMap.remove(temporaryKey);
                }
            }
        }
        return this.flowExecutorConfig.flowContext;
    }

    public QuickFlowExecutor save() {
        if (this.flowExecutorConfig.flowConfig.businessMap.containsKey(this.flowExecutorConfig.name)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u4fdd\u5b58\u8be5\u6d41\u7a0b!\u6d41\u7a0b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!\u6d41\u7a0b\u540d\u79f0:" + this.flowExecutorConfig.name);
        }
        BusinessFlow businessFlow = new BusinessFlow(){

            @Override
            public void executeBusinessFlow(FlowContext flowContext) throws Exception {
                flowContext.putData(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.dataMap);
                QuickFlowExecutor quickFlowExecutor = flowContext.startSubFlow(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.name);
                if (null != ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.tryCatchFinallyHandler) {
                    quickFlowExecutor.tryCatchFinallyHandler(((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.tryCatchFinallyHandler);
                }
                for (BusinessFlow flow : ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.flowList) {
                    quickFlowExecutor.next(flow);
                }
                quickFlowExecutor.execute();
            }

            @Override
            public String name() {
                return ((QuickFlowExecutor)QuickFlowExecutor.this).flowExecutorConfig.name;
            }
        };
        this.flowExecutorConfig.flowConfig.businessMap.put(this.flowExecutorConfig.name, businessFlow);
        return this;
    }

    private void printFlowTrace(String content) {
        if (this.flowExecutorConfig.printTrace && this.flowExecutorConfig.flowConfig.printTrace) {
            for (int i = 0; i < this.flowExecutorConfig.subflowLevel; ++i) {
                this.flowExecutorConfig.printTraceBuilder.append("\t");
            }
            this.flowExecutorConfig.printTraceBuilder.append(content + "\r\n");
        }
    }
}

