package cn.schoolwow.quickflow.domain;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.exception.BrokenException;
import cn.schoolwow.quickflow.flow.Flow;

import java.util.Map;

public class FlowContextImpl implements FlowContext {
    /**
     * 配置数据
     */
    private FlowExecutorConfig flowExecutorConfig;

    public FlowContextImpl(FlowExecutorConfig flowExecutorConfig) {
        this.flowExecutorConfig = flowExecutorConfig;
    }

    @Override
    public Object checkData(String key) {
        Object value = getData(key);
        if(null==value){
            throw new IllegalArgumentException("上下文数据key为"+key+"的值!");
        }
        return value;
    }

    @Override
    public Object getData(String key) {
        return flowExecutorConfig.dataMap.get(key);
    }

    @Override
    public Map<String, Object> getData() {
        return flowExecutorConfig.dataMap;
    }

    @Override
    public void putData(String key, Object value) {
        flowExecutorConfig.dataMap.put(key, value);
    }

    @Override
    public void putData(Map<String, Object> map) {
        flowExecutorConfig.dataMap.putAll(map);
    }

    @Override
    public void removeData(String key) {
        flowExecutorConfig.dataMap.remove(key);
    }

    @Override
    public void broken(String reason) {
        throw new BrokenException(reason);
    }

    @Override
    public String getFlowName() {
        return flowExecutorConfig.name;
    }

    @Override
    public String getFlowTrace() {
        return flowExecutorConfig.printTraceBuilder.toString();
    }

    @Override
    public Exception getFlowException() {
        return flowExecutorConfig.exception;
    }

    @Override
    public String getBrokenReason() {
        return flowExecutorConfig.brokenReason;
    }

    @Override
    public QuickFlowExecutor startSubFlow(String name) {
        if (this.flowExecutorConfig.flowConfig.printTrace) {
            for(int i=0;i<this.flowExecutorConfig.subflowLevel;i++){
                this.flowExecutorConfig.printTraceBuilder.append("----");
            }
            Flow currentFlow = this.flowExecutorConfig.flowList.get(this.flowExecutorConfig.index);
            this.flowExecutorConfig.printTraceBuilder.append("["+this.flowExecutorConfig.index+"]"+currentFlow.name() + "\r\n");
        }

        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = new FlowContextImpl(flowExecutorConfig);
        flowExecutorConfig.dataMap = this.flowExecutorConfig.dataMap;
        flowExecutorConfig.subflowLevel = this.flowExecutorConfig.subflowLevel+1;
        flowExecutorConfig.parentFlowExecutorConfig = this.flowExecutorConfig;
        flowExecutorConfig.flowConfig = this.flowExecutorConfig.flowConfig;
        if(flowExecutorConfig.flowConfig.printTrace){
            flowExecutorConfig.printTraceBuilder = this.flowExecutorConfig.printTraceBuilder;
        }
        return new QuickFlowExecutor(flowExecutorConfig);
    }

}
