package cn.schoolwow.quickflow;

import cn.schoolwow.quickflow.domain.FlowConfig;
import cn.schoolwow.quickflow.domain.FlowContextImpl;
import cn.schoolwow.quickflow.domain.FlowExecutorConfig;
import cn.schoolwow.quickflow.listener.QuickFlowListener;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class QuickFlow {
    private Logger logger = LoggerFactory.getLogger(QuickFlow.class);

    private FlowConfig flowConfig = new FlowConfig();

    private boolean build;

    public static QuickFlow newInstance() {
        return new QuickFlow();
    }

    /**
     * 指定异步任务执行线程池
     */
    public QuickFlow threadPool(ThreadPoolExecutor threadPoolExecutor) {
        flowConfig.threadPoolExecutor = threadPoolExecutor;
        return this;
    }

    /**
     * 事件监听
     */
    public QuickFlow flowListener(QuickFlowListener quickFlowListener) {
        flowConfig.quickFlowListener = quickFlowListener;
        return this;
    }

    /**
     * 是否打印执行路径
     */
    public QuickFlow printTrace(boolean printTrace) {
        flowConfig.printTrace = printTrace;
        return this;
    }

    /**
     * 是否记录流程耗时
     */
    public QuickFlow printConsumeTime(boolean printConsumeTime) {
        flowConfig.printConsumeTime = printConsumeTime;
        return this;
    }

    /**
     * 指定try-catch-finally处理器
     */
    public QuickFlow tryCatchFinallyHandler(TryCatchFinallyHandler tryCatchFinallyHandler) {
        flowConfig.tryCatchFinallyHandler = tryCatchFinallyHandler;
        return this;
    }

    /**
     * 生成对象
     */
    public QuickFlow build() {
        //判断有无异步任务
        if (null == flowConfig.threadPoolExecutor) {
            flowConfig.threadPoolExecutor = (ThreadPoolExecutor) Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        }
        build = true;
        return this;
    }

    /**构建流程*/
    public QuickFlowExecutor startFlow() {
        return startFlow("QuickFlow");
    }

    /**构建流程*/
    public QuickFlowExecutor startFlow(String name) {
        if (!build) {
            throw new UnsupportedOperationException("请先调用build方法!");
        }
        FlowExecutorConfig flowExecutorConfig = new FlowExecutorConfig();
        flowExecutorConfig.name = name;
        flowExecutorConfig.flowContext = new FlowContextImpl(flowExecutorConfig);
        flowExecutorConfig.dataMap = new ConcurrentHashMap<>();
        flowExecutorConfig.flowConfig = flowConfig;
        if(flowConfig.printTrace){
            flowExecutorConfig.printTraceBuilder = new StringBuilder();
        }
        return new QuickFlowExecutor(flowExecutorConfig);
    }

}
