package cn.schoolwow.quickdao.flow.initial;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.ddl.createTable.CreateTableFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Collection;

public class AutomaticCreateTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        if(!quickDAOConfig.databaseOption.automaticCreateTable){
            flowContext.remark("跳过自动建表");
            return;
        }

        Collection<Entity> entityList = quickDAOConfig.databaseContext.entityMap.values();
        for (Entity entity : entityList) {
            Entity databaseEntity = quickDAOConfig.getDatabaseEntityByTableName(entity.tableName);
            if (null == databaseEntity) {
                flowContext.startFlow(new CreateTableFlow())
                        .putTemporaryData("entity", entity)
                        .execute();
            }
        }
    }

    @Override
    public String name() {
        return "自动建表";
    }
}
