package cn.schoolwow.quickdao.flow.initial;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Collection;

public class AutomaticCreateColumnFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        if(!quickDAOConfig.databaseOption.automaticCreateProperty){
            flowContext.remark("跳过自动新增列");
            return;
        }

        Collection<Entity> entityList = quickDAOConfig.databaseContext.entityMap.values();
        for (Entity entity : entityList) {
            flowContext.startFlow(new CompareAndCreateColumnFlow())
                    .putTemporaryData("entity", entity)
                    .printTrace(false)
                    .execute();
        }
    }

    @Override
    public String name() {
        return "自动新增列";
    }
}
