package cn.schoolwow.quickdao.flow.executor;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.entity.SqlLog;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.executor.common.BeforeExecuteFlow;
import cn.schoolwow.quickdao.flow.executor.common.ExecuteFailFlow;
import cn.schoolwow.quickdao.flow.executor.common.InsertSqlLogFlow;
import cn.schoolwow.quickdao.flow.executor.common.SetPrepareStatementParameterFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.*;
import java.util.StringTokenizer;

public class ExecuteUpdateConnectionFlow implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(ExecuteUpdateConnectionFlow.class);

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new BeforeExecuteFlow());
        int effect = executeUpdate(flowContext);
        flowContext.putData("effect", effect);
    }

    @Override
    public String name() {
        return "执行更新语句";
    }

    private int executeUpdate(FlowContext flowContext) throws SQLException {
        String name = (String) flowContext.checkData("name");
        String sql = (String) flowContext.checkData("sql");
        String formatSQL = (String) flowContext.checkData("formatSQL");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");

        flowContext.putTemporaryData("startTime", System.currentTimeMillis());
        String executeSQL = sql;
        int indexOfSemicolon = sql.indexOf(";");
        try {
            int effect = 0;
            if (indexOfSemicolon>=0&&indexOfSemicolon!=sql.length()-1) {
                StringTokenizer st = new StringTokenizer(sql, ";");
                while (st.hasMoreTokens()) {
                    executeSQL = st.nextToken();
                    effect += doExecuteUpdate(executeSQL, flowContext);
                }
            } else {
                effect += doExecuteUpdate(executeSQL, flowContext);
            }
            flowContext.startFlow(new InsertSqlLogFlow())
                    .putData("effect", effect)
                    .putTemporaryData("sqlLogType", 1)
                    .execute();
            SqlLog sqlLog = (SqlLog) flowContext.checkData("sqlLog");
            logger.debug("[更新]名称:{},耗时:{}ms,影响行数:{},执行语句:{}", name, sqlLog.getConsumeTime(), effect, formatSQL);
            if(quickDAOConfig.logRecordOption.record&&!"插入SQL日志".equalsIgnoreCase(name)){
                quickDAOConfig.logRecordOption.sqlRecordBuilder.append("[更新]名称:"+name+",耗时:"+sqlLog.getConsumeTime()+"ms,影响行数:"+effect+",执行语句:"+formatSQL+"\r\n");
            }
            return effect;
        } catch (Exception e) {
            flowContext.startFlow(new InsertSqlLogFlow())
                    .next(new ExecuteFailFlow())
                    .putTemporaryData("exception", e)
                    .putTemporaryData("sqlLogType", 1)
                    .execute();
            throw e;
        }finally {
            flowContext.removeData("parameters");
        }
    }

    private int doExecuteUpdate(String sql, FlowContext flowContext) throws SQLException {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Connection transactionConnection = (Connection) flowContext.getData("transactionConnection");

        if(null==transactionConnection){
            try (Connection connection = quickDAOConfig.databaseContext.dataSource.getConnection()){
                return executeConnectionUpdate(sql, connection, flowContext);
            }
        }else{
            return executeConnectionUpdate(sql, transactionConnection, flowContext);
        }
    }

    private int executeConnectionUpdate(String sql, Connection connection, FlowContext flowContext) throws SQLException {
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.getData("manipulationOption");
        boolean returnGeneratedKeys = null != manipulationOption && manipulationOption.returnGeneratedKeys;

        try (PreparedStatement preparedStatement = returnGeneratedKeys ?
                connection.prepareStatement(sql, Statement.RETURN_GENERATED_KEYS) :
                connection.prepareStatement(sql)){
            flowContext.startFlow(new SetPrepareStatementParameterFlow())
                    .putTemporaryData("preparedStatement", preparedStatement)
                    .execute();
            int effect = preparedStatement.executeUpdate();
            if (returnGeneratedKeys) {
                setReturnGenerateKeys(preparedStatement, flowContext);
            }
            return effect;
        }
    }

    private void setReturnGenerateKeys(PreparedStatement preparedStatement, FlowContext flowContext) throws SQLException {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");

        switch (databaseType){
            case Oracle:{
                String tableName = (String) flowContext.checkData("tableName");
                flowContext.getQuickFlow().startFlow(new ExecuteQueryConnectionFlow())
                        .putTemporaryData("name", "获取自增id")
                        .putTemporaryData("sql", "select " + tableName + "_seq.currVal from dual")
                        .putReturnData("resultSetConsumer",new ResultSetConsumer() {
                            @Override
                            public void consumeResultSet(ResultSet resultSet) throws Exception {
                                if (resultSet.next()) {
                                    flowContext.putData("generateKeys", resultSet.getString(1));
                                }
                            }
                        })
                        .execute();
            }break;
            default:{
                try (ResultSet resultSet = preparedStatement.getGeneratedKeys();) {
                    if (resultSet.next()) {
                        flowContext.putData("generateKeys", resultSet.getString(1));
                    }
                }
            }
        }
    }
}
