package cn.schoolwow.quickdao.flow.dql.response.update;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SQLiteUpdateStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        StringBuilder sqlBuilder = new StringBuilder();
        if(!queryContext.join.isEmpty()){
            throw new IllegalArgumentException("SQLite数据库不支持update语句进行表连接操作!");
        }
        sqlBuilder.append("update " + quickDAOConfig.databaseContext.databaseProvider.escape(queryContext.queryOption.queryTableOption.entity.tableName) + " ");
        sqlBuilder.append(queryContext.set);
        sqlBuilder.append(queryContext.noAliasNameWhere);
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    @Override
    public String name() {
        return "SQLite数据库更新语句";
    }
}
