package cn.schoolwow.quickdao.flow.dql.response.update;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class DefaultUpdateStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("update " + quickDAOConfig.databaseContext.databaseProvider.escape(queryContext.queryOption.queryTableOption.entity.tableName) + " " + queryContext.queryOption.queryTableOption.tableAliasName + " ");
        sqlBuilder.append(queryContext.join);
        sqlBuilder.append(queryContext.set);
        sqlBuilder.append(queryContext.where);
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    @Override
    public String name() {
        return "数据库默认更新语句";
    }
}
