package cn.schoolwow.quickdao.flow.dql.response.delete;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOption;
import cn.schoolwow.quickdao.provider.DatabaseProvider;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class PostgresDeleteStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");
        DatabaseProvider databaseProvider = quickDAOConfig.databaseContext.databaseProvider;

        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from " + databaseProvider.escape(queryContext.queryOption.queryTableOption.entity.tableName)
                + " " + queryContext.queryOption.queryTableOption.tableAliasName + " ");
        if(!queryContext.queryOption.subQueryOptionList.isEmpty()){
            sqlBuilder.append(" using ");
            for(SubQueryOption subQueryOption:queryContext.queryOption.subQueryOptionList){
                sqlBuilder.append(databaseProvider.escape(subQueryOption.subQueryTableOption.entity.tableName)+" "+subQueryOption.subQueryTableOption.tableAliasName+",");
            }
            sqlBuilder.deleteCharAt(sqlBuilder.length()-1);

            //添加where语句的关联语句
            StringBuilder whereBuilder = new StringBuilder();
            for(SubQueryOption subQueryOption:queryContext.queryOption.subQueryOptionList){
                if (null != subQueryOption.subQueryJoinTableOption.primaryField && null != subQueryOption.subQueryJoinTableOption.joinTableField) {
                    if (subQueryOption.subQueryJoinTableOption.parentSubQueryOption == null) {
                        //子表关联主表
                        whereBuilder.append(subQueryOption.subQueryJoinTableOption.queryOption.queryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(subQueryOption.subQueryJoinTableOption.primaryField));
                    } else {
                        //子表关联子表
                        whereBuilder.append(subQueryOption.subQueryJoinTableOption.parentSubQueryOption.subQueryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(subQueryOption.subQueryJoinTableOption.primaryField));
                    }
                    whereBuilder.append(" = " + subQueryOption.subQueryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(subQueryOption.subQueryJoinTableOption.joinTableField) + " ");
                    whereBuilder.append(" and ");
                }
            }
            whereBuilder.delete(whereBuilder.length()-5, whereBuilder.length());
            if(queryContext.where.isEmpty()){
                sqlBuilder.append("where "+whereBuilder+" ");
            }else{
                sqlBuilder.append(queryContext.where.replace("where ", "where "+whereBuilder.toString()+" and "));
            }
        }else{
            sqlBuilder.append(queryContext.where);
        }
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    @Override
    public String name() {
        return "Postgres数据库删除语句";
    }
}
