package cn.schoolwow.quickdao.flow.dql.response.delete;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOption;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;

public class DeleteFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        setParameters(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "根据查询条件删除记录";
    }

    private void setStatement(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");

        switch (databaseType){
            case SQLite:{
                flowContext.executeFlowList(new SQLiteDeleteStatementFlow());
            }break;
            case Postgresql:{
                flowContext.executeFlowList(new PostgresDeleteStatementFlow());
            }break;
            default:{
                flowContext.executeFlowList(new DefaultDeleteStatementFlow());
            }break;
        }
    }

    private void setParameters(FlowContext flowContext) {
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        List<Object> parameters = new ArrayList<>();
        parameters.addAll(queryContext.joinParameters);
        parameters.addAll(queryContext.whereParameters);

        for(SubQueryOption subQueryOption:queryContext.queryOption.subQueryOptionList){
            parameters.addAll(subQueryOption.subQueryFragmentOption.whereParameterList);
            parameters.addAll(subQueryOption.subQueryFragmentOption.havingParameterList);
        }

        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext) throws Exception {
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "根据查询条件删除记录")
                .execute();
    }

}
