package cn.schoolwow.quickdao.flow.dql.response.common;

import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;

public class SetConditionParameterFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        List<Object> parameters = new ArrayList<>();
        parameters.addAll(queryContext.selectParameters);
        parameters.addAll(queryContext.fromParameters);
        parameters.addAll(queryContext.joinParameters);
        parameters.addAll(queryContext.whereParameters);
        parameters.addAll(queryContext.havingParameters);
        for(SubQueryOption subQueryOption:queryContext.queryOption.subQueryOptionList){
            parameters.addAll(subQueryOption.subQueryFragmentOption.whereParameterList);
            parameters.addAll(subQueryOption.subQueryFragmentOption.havingParameterList);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    @Override
    public String name() {
        return "设置复杂查询参数列表";
    }
}
