package cn.schoolwow.quickdao.flow.dql.exist.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GetCountBySingleKeyFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        setParameters(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "根据单个字段查询记录个数";
    }

    private void setStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        Object[] instances = (Object[]) flowContext.checkData("instances");
        Property singleProperty = (Property) flowContext.checkData("singleProperty");
        
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select count(1) from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " where ");
        sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(singleProperty.column) + " in (");
        for(int i=0;i<instances.length;i++){
            sqlBuilder.append("?,");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length()-1);
        sqlBuilder.append(")");
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    private void setParameters(FlowContext flowContext) {
        Property singleProperty = (Property) flowContext.checkData("singleProperty");

        List<Object> parameters = new ArrayList<>();
        Object[] instances = (Object[]) flowContext.checkData("instances");
        for(int i=0;i<instances.length;i++){
            Object value = ParametersUtil.getFieldValueFromInstance(instances[i], singleProperty.name);
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext){
        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("name", "根据单个字段查询记录个数")
                .putReturnData("resultSetConsumer",new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        if(resultSet.next()){
                            flowContext.putData("count", resultSet.getLong(1));
                        }
                    }
                })
                .execute();
    }

}
