package cn.schoolwow.quickdao.flow.dql.condition.update;

import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.domain.internal.dql.common.SQLFragmentEntry;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetUpdateFragmentFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        if(queryContext.queryOption.queryUpdateOption.setList.isEmpty()){
            return;
        }
        StringBuilder sqlBuilder = new StringBuilder("set ");
        for(SQLFragmentEntry fieldFragmentEntry: queryContext.queryOption.queryUpdateOption.setList){
            if(null!=fieldFragmentEntry.field&&fieldFragmentEntry.fragment.contains("{}")){
                Property property = queryContext.queryOption.queryTableOption.entity.getPropertyByFieldNameOrColumnName(fieldFragmentEntry.field);
                if(null==property){
                    sqlBuilder.append(fieldFragmentEntry.fragment.replace("{}", fieldFragmentEntry.field));
                }else if(null==property.function){
                    sqlBuilder.append(fieldFragmentEntry.fragment.replace("{}", quickDAOConfig.databaseContext.databaseProvider.escape(property.column)));
                }else{
                    sqlBuilder.append(fieldFragmentEntry.fragment.replace("{}", property.column).replace("?", property.function));
                }
            }else{
                sqlBuilder.append(fieldFragmentEntry.fragment);
            }
            sqlBuilder.append(fieldFragmentEntry.concat);
        }
        int deleteLength = queryContext.queryOption.queryUpdateOption.setList.get(queryContext.queryOption.queryUpdateOption.setList.size()-1).concat.length();
        sqlBuilder.delete(sqlBuilder.length()-deleteLength, sqlBuilder.length());
        queryContext.set = sqlBuilder.toString();

        queryContext.setParameters = queryContext.queryOption.queryUpdateOption.setParameterList;
    }

    @Override
    public String name() {
        return "拼接更新语句片段";
    }

}
