package cn.schoolwow.quickdao.flow.dql.condition.set;

import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOption;
import cn.schoolwow.quickdao.flow.dql.common.SetSingleJoinTableStatementFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetJoinTableFragmentFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        StringBuilder sqlBuilder = new StringBuilder();
        for(SubQueryOption subQueryOption:queryContext.queryOption.subQueryOptionList){
            flowContext.startFlow(new SetSingleJoinTableStatementFlow())
                    .putCurrentCompositeFlowData("subQueryOption", subQueryOption)
                    .putCurrentCompositeFlowData("sqlBuilder", sqlBuilder)
                    .execute();
        }
        if(sqlBuilder.length()>0){
            queryContext.join = sqlBuilder.toString();
        }
    }

    @Override
    public String name() {
        return "设置查询表语句片段";
    }

}
