package cn.schoolwow.quickdao.flow.dql.common;

import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOnCondition;
import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOption;
import cn.schoolwow.quickdao.provider.DatabaseProvider;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetJoinTableOnAndStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        SubQueryOption subQueryOption = (SubQueryOption) flowContext.checkData("subQueryOption");
        StringBuilder sqlBuilder = (StringBuilder) flowContext.checkData("sqlBuilder");
        DatabaseProvider databaseProvider = (DatabaseProvider) flowContext.checkData("databaseProvider");

        for(SubQueryOnCondition subQueryOnCondition:subQueryOption.subQueryJoinTableOption.onConditionList){
            sqlBuilder.append(" and ");

            sqlBuilder.append(subQueryOption.subQueryTableOption.tableAliasName);
            sqlBuilder.append(".");
            sqlBuilder.append(subQueryOnCondition.childTableFieldName);
            sqlBuilder.append("=");

            if(null!=subQueryOnCondition.parentTableAliasName){
                String parentTableFieldName = null;
                if(subQueryOnCondition.parentTableAliasName.equalsIgnoreCase(subQueryOption.subQueryJoinTableOption.queryOption.queryTableOption.tableAliasName)){
                    parentTableFieldName = subQueryOption.subQueryJoinTableOption.queryOption.queryTableOption.entity.getColumnNameByFieldName(subQueryOnCondition.parentTableFieldName);
                }else{
                    for(SubQueryOption currentSubQueryOption:subQueryOption.subQueryJoinTableOption.queryOption.subQueryOptionList){
                        if(currentSubQueryOption.subQueryTableOption.tableAliasName.equalsIgnoreCase(subQueryOnCondition.parentTableAliasName)){
                            parentTableFieldName = currentSubQueryOption.subQueryJoinTableOption.queryOption.queryTableOption.entity.getColumnNameByFieldName(subQueryOnCondition.parentTableFieldName);
                            break;
                        }
                    }
                }
                if(null==parentTableFieldName){
                    throw new IllegalArgumentException("表别名不存在!表别名:"+subQueryOnCondition.parentTableAliasName);
                }
                subQueryOnCondition.parentTableFieldName = parentTableFieldName;
                //用户自定义表别名
                sqlBuilder.append(subQueryOnCondition.parentTableAliasName);
            }else if (subQueryOption.subQueryJoinTableOption.parentSubQueryOption == null) {
                //主表关联子表
                sqlBuilder.append(subQueryOption.subQueryJoinTableOption.queryOption.queryTableOption.tableAliasName);
            } else {
                //父表关联子表
                sqlBuilder.append(subQueryOption.subQueryJoinTableOption.parentSubQueryOption.subQueryTableOption.tableAliasName);
            }
            sqlBuilder.append(".");

            String parentTableFieldName = subQueryOnCondition.parentTableFieldName;
            if(null!=subQueryOnCondition.parentTableAliasName){
                //查询表别名字段
                for(SubQueryOption subQueryOption1:subQueryOption.subQueryJoinTableOption.queryOption.subQueryOptionList){
                    if(subQueryOption1.subQueryTableOption.tableAliasName.equalsIgnoreCase(subQueryOnCondition.parentTableAliasName)){
                        parentTableFieldName = subQueryOption1.subQueryTableOption.entity.getColumnNameByFieldName(parentTableFieldName);
                        break;
                    }
                }
            }
            sqlBuilder.append(databaseProvider.escape(parentTableFieldName));
        }
    }

    @Override
    public String name() {
        return "设置连表语句的and部分";
    }
}
