package cn.schoolwow.quickdao.flow.dml.json.update.common;

import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class SetUpdateJSONObjectParameterFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        List<String> columnNameList = (List<String>) flowContext.checkData("columnNameList");
        JSONObject instance = (JSONObject) flowContext.checkData("instance");

        List<Object> parameters = new ArrayList<Object>();
        for(String column:columnNameList){
            Object value = instance.get(column);
            parameters.add(value);
        }
        for(String uniqueFieldName:manipulationOption.uniqueFieldNames){
            Object value = instance.get(uniqueFieldName);
            parameters.add(value);
        }
        flowContext.putData("parameters", parameters);
    }

    @Override
    public String name() {
        return "设置更新JSONObject参数列表";
    }

}
