package cn.schoolwow.quickdao.flow.dml.json.update;

import cn.schoolwow.quickdao.domain.internal.dml.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.common.CheckReasonInstanceMapFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.SetColumnNameListFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.SetJSONObjectEntityFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.check.CheckUniqueFieldNameFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.filter.FilterJSONArrayByConstraintFlow;
import cn.schoolwow.quickdao.flow.dml.json.common.filter.FilterJSONArrayBySameUniqueFieldFlow;
import cn.schoolwow.quickdao.flow.dml.json.update.common.SetUpdateJSONObjectParameterFlow;
import cn.schoolwow.quickdao.flow.dml.json.update.common.SetUpdateJSONObjectStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteBatchUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

public class UpdateJSONArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new SetJSONObjectEntityFlow(),
                new CheckUniqueFieldNameFlow(),
                new FilterJSONArrayBySameUniqueFieldFlow(),
                new FilterJSONArrayByConstraintFlow(),
                new CheckReasonInstanceMapFlow(),
                new SetColumnNameListFlow(),
                new SetUpdateJSONObjectStatementFlow()
        );

        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        JSONArray instances = (JSONArray) flowContext.checkData("instances");

        flowContext.startFlow(new ExecuteBatchUpdateConnectionFlow())
                .putTemporaryData("perBatchCount", manipulationOption.perBatchCount)
                .putTemporaryData("name", "批处理更新JSONArray")
                .putTemporaryData("size", instances.size())
                .putTemporaryData("getBatchParametersSupplier",new GetBatchParametersSupplier() {
                    @Override
                    public List<Object> getBatchParameters(Integer index) throws Exception {
                        JSONObject instance = instances.getJSONObject(index);
                        flowContext.putTemporaryData("instance", instance);
                        flowContext.executeFlowList(new SetUpdateJSONObjectParameterFlow());
                        List<Object> parameters = (List<Object>) flowContext.checkData("parameters");
                        return parameters;
                    }
                })
                .execute();
    }

    @Override
    public String name() {
        return "更新JSONArray";
    }

}
