package cn.schoolwow.quickdao.flow.dml.json.save;

import cn.schoolwow.quickdao.flow.dml.json.common.check.CheckUniqueFieldNameFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.InsertJSONArrayFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.get.DistinguishExistJSONArrayFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.get.GetUniqueFieldValueListFlow;
import cn.schoolwow.quickdao.flow.dml.json.update.UpdateJSONArrayFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;

public class SaveJSONArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new CheckUniqueFieldNameFlow(),
                new GetUniqueFieldValueListFlow(),
                new DistinguishExistJSONArrayFlow()
        );

        int effect = 0;
        //不存在则插入
        {
            JSONArray notExistJSONArray = (JSONArray) flowContext.getData("notExistJSONArray");
            if(null!=notExistJSONArray&&!notExistJSONArray.isEmpty()){
                flowContext.startFlow(new InsertJSONArrayFlow())
                        .putTemporaryData("instances", notExistJSONArray)
                        .execute();
                effect += (Integer)flowContext.checkData("effect");
            }
        }

        //存在则更新
        {
            JSONArray existJSONArray = (JSONArray) flowContext.getData("existJSONArray");
            if(null!=existJSONArray&&!existJSONArray.isEmpty()){
                flowContext.startFlow(new UpdateJSONArrayFlow())
                        .putTemporaryData("instances", existJSONArray)
                        .execute();
                effect += (Integer)flowContext.checkData("effect");
            }
        }

        flowContext.putData("effect", effect);
    }

    @Override
    public String name() {
        return "保存JSONArray";
    }

}
