package cn.schoolwow.quickdao.flow.dml.json.insert;

import cn.schoolwow.quickdao.flow.dml.json.common.check.CheckUniqueFieldNameFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.get.DistinguishExistJSONArrayFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.get.GetUniqueFieldValueListFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;

public class InsertIgnoreJSONArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new CheckUniqueFieldNameFlow(),
                new GetUniqueFieldValueListFlow(),
                new DistinguishExistJSONArrayFlow()
        );
        JSONArray notExistJSONArray = (JSONArray) flowContext.getData("notExistJSONArray");
        if(null!=notExistJSONArray&&!notExistJSONArray.isEmpty()){
            flowContext.startFlow(new InsertJSONArrayFlow())
                    .putTemporaryData("instances", notExistJSONArray)
                    .execute();
        }else{
            flowContext.putData("effect", 0);
        }
    }

    @Override
    public String name() {
        return "忽略插入JSONArray";
    }

}