package cn.schoolwow.quickdao.flow.dml.json.delete.common;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetDeleteJSONObjectStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");

        StringBuilder sqlBuilder = new StringBuilder("delete from " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " where ");
        for(String uniqueFieldName:manipulationOption.uniqueFieldNames){
            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(uniqueFieldName) + " = ? and");
        }
        sqlBuilder.delete(sqlBuilder.length()-4,sqlBuilder.length());
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    @Override
    public String name() {
        return "设置删除JSONObject的SQL语句";
    }

}
