package cn.schoolwow.quickdao.flow.dml.json.delete.common;

import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class SetDeleteJSONObjectParameterFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        String tableName = (String) flowContext.checkData("tableName");
        JSONObject instance = (JSONObject) flowContext.checkData("instance");

        List<Object> parameters = new ArrayList();
        for(String uniqueFieldName:manipulationOption.uniqueFieldNames){
            Object value = instance.get(uniqueFieldName);
            if(null==value){
                throw new IllegalArgumentException("唯一约束字段不能为空!表名:"+tableName+",字段名:"+uniqueFieldName);
            }
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    @Override
    public String name() {
        return "设置删除JSONObject参数列表";
    }

}
