package cn.schoolwow.quickdao.flow.dml.json.common.filter;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.dml.CheckStrategy;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.common.CheckFieldConstraintFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class FilterJSONArrayByConstraintFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        shouldCheck(flowContext);
        filterInstanceByConstraint(flowContext);
    }

    @Override
    public String name() {
        return "过滤字段值不符合字段约束的JSONObject";
    }

    private void shouldCheck(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        CheckStrategy checkStrategy = null!=manipulationOption.checkStrategy?manipulationOption.checkStrategy:quickDAOConfig.databaseOption.checkStrategy;
        if(CheckStrategy.None.equals(checkStrategy)){
            flowContext.brokenCurrentFlow("根据字段约束策略,跳过过滤字段值不符合字段约束的实例");
        }
    }

    private void filterInstanceByConstraint(FlowContext flowContext){
        Entity entity = (Entity) flowContext.checkData("entity");
        JSONArray instances = (JSONArray) flowContext.checkData("instances");
        Map<JSONObject,String> instanceReasonMap = (Map<JSONObject, String>) flowContext.getData("instanceReasonMap", new LinkedHashMap<String,Object>());

        JSONArray filterInstances = new JSONArray();
        filterInstances.addAll(instances);
        Iterator<Object> iterator = filterInstances.iterator();
        while(iterator.hasNext()){
            JSONObject instance = (JSONObject) iterator.next();
            for(Property property:entity.properties){
                Object value = instance.get(property.column);
                String reason = (String) flowContext.getQuickFlow().startFlow(new CheckFieldConstraintFlow())
                        .putTemporaryData("property", property)
                        .putTemporaryData("value", value)
                        .execute()
                        .getData("reason");
                if(null!=reason){
                    if(!instanceReasonMap.containsKey(instance)){
                        instanceReasonMap.put(instance, reason);
                    }else{
                        String oldReason = instanceReasonMap.get(instance);
                        instanceReasonMap.put(instance, oldReason+";"+reason);
                    }
                }
            }
            if(instanceReasonMap.containsKey(instance)){
                iterator.remove();
            }
        }

        if(filterInstances.isEmpty()){
            flowContext.putData("effect", 0);
            flowContext.broken("根据字段约束过滤数据后实例列表为空");
        }
        flowContext.putData("instances", filterInstances);
    }

}
