package cn.schoolwow.quickdao.flow.dml.json.common.check;

import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CheckUniqueFieldNameFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        if(manipulationOption.uniqueFieldNames.isEmpty()){
            throw new IllegalArgumentException("请先调用uniqueFieldNames方法指定唯一性约束字段!");
        }
    }

    @Override
    public String name() {
        return "检查是否设置唯一字段列表";
    }
}
