package cn.schoolwow.quickdao.flow.dml.json.common;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetJSONObjectEntityFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        String tableName = (String) flowContext.checkData("tableName");

        if(!manipulationOption.uniqueFieldNames.isEmpty()){
            return;
        }
        Entity entity = quickDAOConfig.getDatabaseEntityByTableName(tableName);
        if(null==entity){
            throw new IllegalArgumentException("数据库表不存在!表名:" + tableName);
        }
        for(IndexField indexField:entity.indexFieldList){
            if(indexField.indexType.equals(IndexType.UNIQUE)){
                manipulationOption.uniqueFieldNames.addAll(indexField.columns);
            }
        }
        flowContext.putTemporaryData("entity", entity);
    }

    @Override
    public String name() {
        return "设置数据库实体类信息";
    }
}
