package cn.schoolwow.quickdao.flow.dml.json.common;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;

public class SetColumnNameListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        String tableName = (String) flowContext.checkData("tableName");

        List<String> columnNameList = new ArrayList<>();
        if(manipulationOption.partColumnSet.isEmpty()){
            Entity entity = quickDAOConfig.getDatabaseEntityByTableName(tableName);
            for(Property property:entity.properties){
                columnNameList.add(property.column);
            }
            if(null!=entity.id&&entity.id.strategy.equals(IdStrategy.AutoIncrement)){
                columnNameList.remove(entity.id.column);
            }
        }else{
            columnNameList.addAll(manipulationOption.partColumnSet);
        }
        flowContext.putTemporaryData("columnNameList", columnNameList);
    }

    @Override
    public String name() {
        return "设置字段列表";
    }
}
