package cn.schoolwow.quickdao.flow.dml.instance.update.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceStatementFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class SetUpdateInstanceByUniqueKeyStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        if(entity.uniqueProperties.isEmpty()){
            throw new IllegalArgumentException("指定实体类无唯一性约束!表名:"+entity.tableName+",类名:"+entity.clazz.getName());
        }

        flowContext.startFlow(new SetInstanceStatementFlow())
                .putReturnData("sqlCacheName", "updateByUniqueKey_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name())
                .putTemporaryData("getStatementSupplier", new GetStatementSupplier() {
                    @Override
                    public String getStatement() {
                        List<Property> propertyList = (List<Property>) flowContext.checkData("propertyList");

                        StringBuilder sqlBuilder = new StringBuilder();
                        sqlBuilder.append("update " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " set ");
                        for(Property property:propertyList){
                            if (property.id) {
                                continue;
                            }
                            if (property.createdAt) {
                                continue;
                            }
                            if(entity.uniqueProperties.contains(property)){
                                continue;
                            }
                            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " = " + (null == property.function ? "?" : property.function) + ",");
                        }
                        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                        sqlBuilder.append(" where ");
                        for (Property property : entity.properties) {
                            if (property.id) {
                                continue;
                            }
                            if (entity.uniqueProperties.contains(property)) {
                                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " = ? and ");
                            }
                        }
                        sqlBuilder.delete(sqlBuilder.length() - 5, sqlBuilder.length());
                        return sqlBuilder.toString();
                    }
                })
                .execute();
    }

    @Override
    public String name() {
        return "设置根据唯一字段字段更新实例的SQL语句";
    }

}
