package cn.schoolwow.quickdao.flow.dml.instance.update.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceStatementFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class SetUpdateInstanceByIdStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        if(null==entity.id){
            throw new IllegalArgumentException("指定实体类无id属性!表名:"+entity.tableName+",类名:"+entity.clazz.getName());
        }

        flowContext.startFlow(new SetInstanceStatementFlow())
                .putReturnData("sqlCacheName", "updateById_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name())
                .putTemporaryData("getStatementSupplier", new GetStatementSupplier() {
                    @Override
                    public String getStatement() {
                        List<Property> propertyList = (List<Property>) flowContext.checkData("propertyList");

                        StringBuilder sqlBuilder = new StringBuilder();
                        sqlBuilder.append("update " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " set ");
                        for (Property property : propertyList) {
                            if (property.id) {
                                continue;
                            }
                            if (property.createdAt) {
                                continue;
                            }
                            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " = ?,");
                        }
                        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                        sqlBuilder.append(" where " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.id.column) + " = ?");
                        return sqlBuilder.toString();
                    }
                })
                .execute();
    }

    @Override
    public String name() {
        return "设置根据Id更新实例的SQL语句";
    }

}
