package cn.schoolwow.quickdao.flow.dml.instance.update;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.instance.common.CheckInstanceUniqueKeyFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceEntityFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByIdParameterFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByIdStatementFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByUniqueKeyParameterFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByUniqueKeyStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class UpdateInstanceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new SetInstanceEntityFlow(),
                new CheckInstanceUniqueKeyFlow()
        );

        Entity entity = (Entity) flowContext.checkData("entity");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");

        QuickFlowExecutor quickFlowExecutor = null;
        if(UpdateType.UpdateByUniqueKey.equals(manipulationOption.updateType)||!entity.uniqueProperties.isEmpty()){
            quickFlowExecutor = flowContext.startFlow(new SetUpdateInstanceByUniqueKeyStatementFlow())
                    .next(new SetUpdateInstanceByUniqueKeyParameterFlow())
                    .putTemporaryData("name", "根据唯一约束字段更新实例");
        }else{
            quickFlowExecutor = flowContext.startFlow(new SetUpdateInstanceByIdStatementFlow())
                    .next(new SetUpdateInstanceByIdParameterFlow())
                    .putTemporaryData("name", "根据Id更新实例");
        }
        quickFlowExecutor.next(new ExecuteUpdateConnectionFlow()).execute();
    }

    @Override
    public String name() {
        return "更新实例";
    }

}
