package cn.schoolwow.quickdao.flow.dml.instance.update;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.domain.internal.dml.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.common.CheckReasonInstanceMapFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.CheckInstanceUniqueKeyFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceEntityFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.filter.FilterInstanceByConstraintFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByIdParameterFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByIdStatementFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByUniqueKeyParameterFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.common.SetUpdateInstanceByUniqueKeyStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteBatchUpdateConnectionFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class UpdateInstanceArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new SetInstanceEntityFlow(),
                new CheckInstanceUniqueKeyFlow(),
                new FilterInstanceByConstraintFlow(),
                new CheckReasonInstanceMapFlow()
        );

        Entity entity = (Entity) flowContext.checkData("entity");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        Object[] instances = (Object[]) flowContext.checkData("instances");

        QuickFlowExecutor quickFlowExecutor = null;
        if (UpdateType.UpdateByUniqueKey.equals(manipulationOption.updateType) || !entity.uniqueProperties.isEmpty()) {
            quickFlowExecutor = flowContext.startFlow(new SetUpdateInstanceByUniqueKeyStatementFlow())
                    .putTemporaryData("name", "批处理根据唯一约束字段更新实例")
                    .putTemporaryData("getBatchParametersSupplier",new GetBatchParametersSupplier() {
                        @Override
                        public List<Object> getBatchParameters(Integer index) throws Exception {
                            Object instance = instances[index];
                            flowContext.putTemporaryData("instance", instance);
                            flowContext.executeFlowList(new SetUpdateInstanceByUniqueKeyParameterFlow());
                            List<Object> parameters = (List<Object>) flowContext.checkData("parameters");
                            return parameters;
                        }
                    });
        } else {
            quickFlowExecutor = flowContext.startFlow(new SetUpdateInstanceByIdStatementFlow())
                    .putTemporaryData("name", "批处理根据Id更新实例")
                    .putTemporaryData("getBatchParametersSupplier",new GetBatchParametersSupplier() {
                        @Override
                        public List<Object> getBatchParameters(Integer index) throws Exception {
                            Object instance = instances[index];
                            flowContext.putTemporaryData("instance", instance);
                            flowContext.executeFlowList(new SetUpdateInstanceByIdParameterFlow());
                            List<Object> parameters = (List<Object>) flowContext.checkData("parameters");
                            return parameters;
                        }
                    });
        }
        quickFlowExecutor.next(new ExecuteBatchUpdateConnectionFlow())
                .putTemporaryData("perBatchCount", manipulationOption.perBatchCount)
                .putTemporaryData("size", instances.length)
                .execute();
    }

    @Override
    public String name() {
        return "更新实例";
    }

}