package cn.schoolwow.quickdao.flow.dml.instance.save;

import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceEntityFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.InsertInstanceArrayFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.get.DistinguishExistInstanceFlow;
import cn.schoolwow.quickdao.flow.dml.instance.update.UpdateInstanceArrayFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SaveInstanceArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new SetInstanceEntityFlow(),
                new DistinguishExistInstanceFlow()
        );

        int effect = 0;
        //不存在则插入
        {
            Object[] notExistInstances = (Object[]) flowContext.getData("notExistInstances");
            if(null!=notExistInstances&&notExistInstances.length>0){
                flowContext.startFlow(new InsertInstanceArrayFlow())
                        .putTemporaryData("instances", notExistInstances)
                        .execute();
                effect += (Integer)flowContext.checkData("effect");
            }
        }

        //存在则更新
        {
            Object[] existInstances = (Object[]) flowContext.getData("existInstances");
            if(null!=existInstances&&existInstances.length>0){
                flowContext.startFlow(new UpdateInstanceArrayFlow())
                        .putTemporaryData("instances", existInstances)
                        .execute();
                effect += (Integer)flowContext.checkData("effect");
            }
        }
        flowContext.putData("effect", effect);
    }

    @Override
    public String name() {
        return "保存实例数组";
    }

}
