package cn.schoolwow.quickdao.flow.dml.instance.insert.get;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.common.GetAndCacheStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GetUniqueKeyValueListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Entity entity = (Entity) flowContext.checkData("entity");
        if(entity.uniqueProperties.isEmpty()){
            flowContext.brokenCurrentFlow("实体类未设置唯一约束字段!");
        }
        setStatement(flowContext);
        flowContext.putTemporaryData("uniqueKeyValueList", new ArrayList<>());
        Object[] instances = (Object[]) flowContext.checkData("instances");
        for(int i=0;i<instances.length;i++){
            flowContext.putTemporaryData("instance", instances[i]);
            setParameters(flowContext);
            executeStatement(flowContext);
            flowContext.removeData("instance");
        }
    }

    @Override
    public String name() {
        return "根据唯一约束字段查询记录字段值";
    }

    private void setStatement(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");

        flowContext.startFlow(new GetAndCacheStatementFlow())
                .putReturnData("sqlCacheName", "getUniqueKeyValue_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name())
                .putTemporaryData("getStatementSupplier", new GetStatementSupplier() {
                    @Override
                    public String getStatement() {
                        StringBuilder sqlBuilder = new StringBuilder("select");
                        for(Property uniqueProperty:entity.uniqueProperties){
                            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.escape(uniqueProperty.column) + ",");
                        }
                        sqlBuilder.deleteCharAt(sqlBuilder.length()-1);
                        sqlBuilder.append(" from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " where");
                        for(Property uniqueProperty:entity.uniqueProperties){
                            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.escape(uniqueProperty.column) + " = ? and");
                        }
                        sqlBuilder.delete(sqlBuilder.length()-4,sqlBuilder.length());
                        return sqlBuilder.toString();
                    }
                })
                .execute();
    }

    private void setParameters(FlowContext flowContext){
        Entity entity = (Entity) flowContext.checkData("entity");
        Object instance = flowContext.checkData("instance");

        List<Object> parameters = new ArrayList();
        for (Property uniqueProperty : entity.uniqueProperties) {
            Object value = ParametersUtil.getFieldValueFromInstance(instance, uniqueProperty.name);
            if(null==value){
                throw new IllegalArgumentException("实例唯一字段不能为空!实体类:"+instance.getClass().getName()+",字段名:"+uniqueProperty.name);
            }
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext){
        Entity entity = (Entity) flowContext.checkData("entity");
        List<String> uniqueKeyValueList = (List<String>) flowContext.getData("uniqueKeyValueList");

        StringBuilder uniqueFieldNameValueBuilder = new StringBuilder();
        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("name", "根据多个唯一约束字段查询记录字段值")
                .putReturnData("resultSetConsumer",new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        while(resultSet.next()){
                            uniqueFieldNameValueBuilder.setLength(0);
                            for(Property uniqueProperty:entity.uniqueProperties){
                                uniqueFieldNameValueBuilder.append(resultSet.getString(uniqueProperty.column)+"|");
                            }
                            uniqueKeyValueList.add(uniqueFieldNameValueBuilder.toString());
                        }
                    }
                })
                .execute();
    }

}
