package cn.schoolwow.quickdao.flow.dml.instance.insert.get;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DistinguishExistInstanceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Entity entity = (Entity) flowContext.checkData("entity");
        Set<Object> existInstanceSet = new HashSet<>();
        flowContext.putTemporaryData("existInstanceSet", existInstanceSet);
        if(entity.uniqueProperties.size()==1){
            distinguishBySingleProperty(entity.uniqueProperties.get(0), flowContext);
        }
        if(null!=entity.id){
            distinguishBySingleProperty(entity.id, flowContext);
        }
        if(entity.uniqueProperties.size()>1){
            distinguishByUniqueKey(flowContext);
        }
        setNotExistInstanceSet(flowContext);

        Set<Object> notExistInstanceSet = (Set<Object>) flowContext.getData("notExistInstanceSet");
        if(existInstanceSet.isEmpty()&&notExistInstanceSet.isEmpty()){
            throw new IllegalArgumentException("逻辑执行异常!存在实例和不存在实例个数都为0!");
        }
        flowContext.putTemporaryData("existInstances", existInstanceSet.toArray(new Object[0]));
        flowContext.putTemporaryData("notExistInstances", notExistInstanceSet.toArray(new Object[0]));
        flowContext.removeData("existInstanceSet");
        flowContext.removeData("notExistInstanceSet");
    }

    @Override
    public String name() {
        return "区分实例是否存在";
    }

    private void distinguishBySingleProperty(Property singleProperty, FlowContext flowContext){
        Set<Object> existInstanceSet = (Set<Object>) flowContext.getData("existInstanceSet");
        Object[] instances = (Object[]) flowContext.checkData("instances");

        flowContext.startFlow(new GetSinglePropertyValueListFlow())
                .putTemporaryData("singleProperty", singleProperty)
                .execute();
        List<String> singlePropertyValueList = (List<String>) flowContext.getData("singlePropertyValueList");
        if(singlePropertyValueList.isEmpty()){
            return;
        }
        for(int i=0;i<instances.length;i++){
            Object instance = instances[i];

            String singlePropertyValue = ParametersUtil.getFieldValueFromInstance(instance, singleProperty.name).toString();
            if(null==singlePropertyValue){
                throw new IllegalArgumentException("实例指定字段不能为空!实体类:"+instance.getClass().getName()+",字段名:"+singleProperty.name);
            }
            if(singlePropertyValueList.contains(singlePropertyValue)){
                existInstanceSet.add(instance);
            }
        }
    }

    private void distinguishByUniqueKey(FlowContext flowContext){
        Set<Object> existInstanceSet = (Set<Object>) flowContext.getData("existInstanceSet");
        Entity entity = (Entity) flowContext.checkData("entity");
        Object[] instances = (Object[]) flowContext.checkData("instances");

        flowContext.executeFlowList(new GetUniqueKeyValueListFlow());
        List<String> uniqueKeyValueList = (List<String>) flowContext.getData("uniqueKeyValueList");
        if(uniqueKeyValueList.isEmpty()){
            return;
        }

        StringBuilder uniqueFieldNameValueBuilder = new StringBuilder();
        for(int i=0;i<instances.length;i++){
            uniqueFieldNameValueBuilder.setLength(0);

            Object instance = instances[i];
            for(Property uniqueProperty:entity.uniqueProperties){
                Object value = ParametersUtil.getFieldValueFromInstance(instance, uniqueProperty.name);
                if(null==value){
                    throw new IllegalArgumentException("实例唯一字段不能为空!实体类:"+instance.getClass().getName()+",字段名:"+uniqueProperty.name);
                }
                uniqueFieldNameValueBuilder.append(value+"|");
            }
            if(uniqueKeyValueList.contains(uniqueFieldNameValueBuilder.toString())){
                existInstanceSet.add(instance);
            }
        }
    }

    private void setNotExistInstanceSet(FlowContext flowContext){
        Set<Object> existInstanceSet = (Set<Object>) flowContext.getData("existInstanceSet");
        Object[] instances = (Object[]) flowContext.checkData("instances");

        if(existInstanceSet.isEmpty()){
            flowContext.putData("notExistInstanceSet", new HashSet<>(Arrays.asList(instances)));
            return;
        }

        Set<Object> notExistInstanceSet = new HashSet<>();
        for(int i=0;i<instances.length;i++){
            if(!existInstanceSet.contains(instances[i])){
                notExistInstanceSet.add(instances[i]);
            }
        }
        flowContext.putData("notExistInstanceSet", notExistInstanceSet);
    }

}
