package cn.schoolwow.quickdao.flow.dml.instance.insert;

import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceEntityFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.get.DistinguishExistInstanceFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class InsertIgnoreInstanceArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new SetInstanceEntityFlow(),
                new DistinguishExistInstanceFlow()
        );
        Object[] notExistInstances = (Object[]) flowContext.getData("notExistInstances");
        if(null!=notExistInstances&&notExistInstances.length>0){
            flowContext.startFlow(new InsertInstanceArrayFlow())
                    .putTemporaryData("instances", notExistInstances)
                    .execute();
        }else{
            flowContext.putData("effect", 0);
        }
    }

    @Override
    public String name() {
        return "忽略插入实例数组";
    }

}