package cn.schoolwow.quickdao.flow.dml.instance.delete;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.instance.common.CheckInstanceUniqueKeyFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceEntityFlow;
import cn.schoolwow.quickdao.flow.dml.instance.delete.common.DeleteByMultipleUniqueKeyFlow;
import cn.schoolwow.quickdao.flow.dml.instance.delete.common.DeleteBySingleUniqueKeyFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class DeleteInstanceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new SetInstanceEntityFlow(),
                new CheckInstanceUniqueKeyFlow()
        );

        Entity entity = (Entity) flowContext.checkData("entity");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");

        QuickFlowExecutor quickFlowExecutor = null;
        if(UpdateType.UpdateByUniqueKey.equals(manipulationOption.updateType)||!entity.uniqueProperties.isEmpty()){
            if(entity.uniqueProperties.size()==1){
                quickFlowExecutor = flowContext.startFlow(new DeleteBySingleUniqueKeyFlow())
                        .putTemporaryData("uniqueKeyProperty", entity.uniqueProperties.get(0));
            }else{
                quickFlowExecutor = flowContext.startFlow(new DeleteByMultipleUniqueKeyFlow());
            }
        }else{
            //根据id删除
            quickFlowExecutor = flowContext.startFlow(new DeleteBySingleUniqueKeyFlow())
                    .putTemporaryData("uniqueKeyProperty", entity.id);
        }
        quickFlowExecutor.execute();
    }

    @Override
    public String name() {
        return "删除实例";
    }

}
