package cn.schoolwow.quickdao.flow.dml.instance.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CheckInstanceUniqueKeyFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Entity entity = (Entity) flowContext.checkData("entity");
        if(null==entity.id&&entity.uniqueProperties.isEmpty()){
            throw new UnsupportedOperationException("指定实体类既无id又无唯一性约束!无法进行更新或者删除操作!!实体类:"+entity.clazz.getName());
        }
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        if(null==manipulationOption.updateType&&null!=entity.id&&!entity.uniqueProperties.isEmpty()) {
            throw new UnsupportedOperationException("指定实体类既有id又有唯一性约束!请调用updateType方法指定更新类型!实体类:"+entity.clazz.getName());
        }
        if(UpdateType.UpdateByUniqueKey.equals(manipulationOption.updateType)||!entity.uniqueProperties.isEmpty()){
            int updateColumnCount = 0;
            for(Property property:entity.properties){
                if(property.id){
                    continue;
                }
                if(entity.uniqueProperties.contains(property)){
                    continue;
                }
                updateColumnCount++;
            }
            if(updateColumnCount==0){
                throw new IllegalArgumentException("指定实体类字段全部为id字段或者唯一约束字段!无法进行更新或者删除操作!实体类:"+entity.clazz.getName());
            }
        }
        manipulationOption.returnGeneratedKeys = false;
    }

    @Override
    public String name() {
        return "检查实例唯一约束";
    }
}
