package cn.schoolwow.quickdao.flow.dml.common;

import cn.schoolwow.quickdao.domain.external.dml.CheckStrategy;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.HashMap;
import java.util.Map;

public class CheckReasonInstanceMapFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        Map<Object,String> instanceReasonMap = (Map<Object, String>) flowContext.getData("instanceReasonMap", new HashMap<String,Object>());

        if(!instanceReasonMap.isEmpty()){
            flowContext.remark("存在不符合字段约束的实例");
            if(CheckStrategy.CheckAndThrow.equals(manipulationOption.checkStrategy)){
                String reason = instanceReasonMap.values().iterator().next();
                throw new IllegalArgumentException("实例数组存在不符合字段约束的实例!个数:"+instanceReasonMap.size()+",部分违反字段约束原因:"+reason);
            }
        }
    }

    @Override
    public String name() {
        return "检查字段约束策略实例列表";
    }
}
