package cn.schoolwow.quickdao.flow.dml;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickdao.provider.DatabaseProvider;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class TruncateTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        String tableName = (String) flowContext.checkData("tableName");
        DatabaseProvider databaseProvider = quickDAOConfig.databaseContext.databaseProvider;

        switch (databaseType){
            case Postgresql:{
                flowContext.putTemporaryData("sql", "truncate table " + databaseProvider.escape(tableName) + " restart identity cascade;");
            }break;
            default:{
                flowContext.putTemporaryData("sql", "truncate table " + databaseProvider.escape(tableName));
            }break;
        }
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "清空表")
                .execute();
    }

    @Override
    public String name() {
        return "清空表";
    }
}
