package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class RenameTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setRenameStatement(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "重命名表";
    }

    private void setRenameStatement(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String oldTableName = (String) flowContext.checkData("oldTableName");
        String newTableName = (String) flowContext.checkData("newTableName");
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");

        oldTableName = StringUtil.camel2Underline(oldTableName);
        newTableName = StringUtil.camel2Underline(newTableName);

        switch (databaseType){
            case Postgresql:{
                flowContext.putTemporaryData("sql", "alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(oldTableName) + " rename to " + quickDAOConfig.databaseContext.databaseProvider.escape(newTableName) + ";");
            }break;
            default:{
                flowContext.putTemporaryData("sql", "rename table " + quickDAOConfig.databaseContext.databaseProvider.escape(oldTableName) + " to " + quickDAOConfig.databaseContext.databaseProvider.escape(newTableName) + ";");
            }break;
        }
    }

    private void executeStatement(FlowContext flowContext){
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "重命名表")
                .execute();
    }
}
