package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class DropTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setDropTableStatement(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "删除表";
    }

    private void setDropTableStatement(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");

        switch (databaseType){
            case Postgresql:{
                flowContext.putTemporaryData("sql", "drop table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " cascade;");
            }break;
            default:{
                flowContext.putTemporaryData("sql", "drop table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + ";");
            }break;
        }
    }

    private void executeStatement(FlowContext flowContext){
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "删除表")
                .execute();
    }
}
