package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class BackupTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        String tableName = (String) flowContext.checkData("tableName");
        String backupTableName = (String) flowContext.checkData("backupTableName");

        switch (databaseType){
            case Mysql:
            case MariaDB:{
                flowContext.putTemporaryData("sql", "create table "+quickDAOConfig.databaseContext.databaseProvider.escape(backupTableName)+" as select * from "+quickDAOConfig.databaseContext.databaseProvider.escape(tableName)+";");
            }break;
            case Postgresql:{
                flowContext.putTemporaryData("sql", "select * into "+quickDAOConfig.databaseContext.databaseProvider.escape(backupTableName)+" from "+quickDAOConfig.databaseContext.databaseProvider.escape(tableName)+";");
            }break;
            default:{
                throw new UnsupportedOperationException("当前不支持"+databaseType.name()+"数据库备份表功能");
            }
        }

        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "备份表")
                .execute();
    }

    @Override
    public String name() {
        return "备份表";
    }
}
