package cn.schoolwow.quickdao.flow.ddl.property;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.external.PropertyOption;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.ddl.common.GetAutoIncrementStatementFlow;
import cn.schoolwow.quickdao.flow.ddl.common.GetEscapeCheckFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class AlterTableColumnFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkCanAlterTableColumn(flowContext);
        flowContext.executeFlowList(new GetEscapeCheckFlow());
        setStatement(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "修改表字段";
    }

    private void checkCanAlterTableColumn(FlowContext flowContext){
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        switch (databaseType){
            case SQLite:{
                throw new IllegalArgumentException("SQLite数据库不支持修改字段");
            }
        }
    }

    private void setStatement(FlowContext flowContext){
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");
        PropertyOption propertyOption = (PropertyOption) flowContext.checkData("propertyOption");
        String escapeCheck = (String) flowContext.getData("escapeCheck");

        StringBuilder sqlBuilder = new StringBuilder("alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName));
        switch (databaseType){
            case SQLServer:
            case Postgresql:{
                sqlBuilder.append(" alter");
            }break;
            default:{
                sqlBuilder.append(" modify");
            }break;
        }
        sqlBuilder.append(" column " + quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.column));
        switch (databaseType){
            case Postgresql:{
                sqlBuilder.append(" type");
            }break;
        }
        sqlBuilder.append(" "+propertyOption.columnType);
        if(!propertyOption.columnType.contains("(")){
            sqlBuilder.append((null == propertyOption.range ? "" : "(" + propertyOption.range + ")"));
        }
        if(propertyOption.id&&propertyOption.strategy.equals(IdStrategy.AutoIncrement)){
            flowContext.startFlow(new GetAutoIncrementStatementFlow())
                    .putTemporaryData("sqlBuilder", sqlBuilder)
                    .execute();
        }
        if (null!=propertyOption.notNull&&propertyOption.notNull) {
            sqlBuilder.append(" not null");
        }
        if (null != propertyOption.defaultValue && !propertyOption.defaultValue.isEmpty()) {
            sqlBuilder.append(" default " + propertyOption.defaultValue);
        }
        if (null != escapeCheck && !escapeCheck.isEmpty()) {
            sqlBuilder.append(" check " + escapeCheck);
        }
        if (null != propertyOption.comment) {
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(propertyOption.comment));
        }
        sqlBuilder.append(";");
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }
    
    private void executeStatement(FlowContext flowContext){
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "修改列")
                .execute();
    }
}
