package cn.schoolwow.quickdao.flow.ddl.index;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class DropIndexFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        String tableName = (String) flowContext.checkData("tableName");
        String indexName = (String) flowContext.checkData("indexName");

        switch (databaseType){
            case H2:
            case MariaDB:
            case Mysql:{
                flowContext.putTemporaryData("sql", "alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " drop index " + quickDAOConfig.databaseContext.databaseProvider.escape(indexName) + ";");
            }break;
            default:{
                flowContext.putTemporaryData("sql", "drop index " + quickDAOConfig.databaseContext.databaseProvider.escape(indexName) + ";");
            }break;
        }

        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "删除索引")
                .execute();
    }

    @Override
    public String name() {
        return "删除索引";
    }

}
