package cn.schoolwow.quickdao.flow.ddl.has.common;

import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;
import java.sql.SQLException;

public class SetHasResultSetFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.putReturnData("resultSetConsumer",new ResultSetConsumer() {
            @Override
            public void consumeResultSet(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    flowContext.putData("hasResult", true);
                }else{
                    flowContext.putData("hasResult", false);
                }
            }
        });
    }

    @Override
    public String name() {
        return "设置检查结果集是否有值的逻辑";
    }
}
