package cn.schoolwow.quickdao.flow.ddl.createTable.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class ExecuteCreateTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        StringBuilder sqlBuilder = (StringBuilder) flowContext.checkData("sqlBuilder");
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "创建表")
                .putTemporaryData("sql", sqlBuilder.toString())
                .execute();
        //缓存表信息
        quickDAOConfig.databaseContext.databaseTableCache.put(entity.tableName, entity);
    }

    @Override
    public String name() {
        return "创建表";
    }
}
