package cn.schoolwow.quickdao.flow.ddl.createTable.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class CheckOpenForeignKeyFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Entity entity = (Entity) flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");

        StringBuilder sqlBuilder = new StringBuilder();
        if (quickDAOConfig.databaseOption.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            //手动开启外键约束
            sqlBuilder.append("PRAGMA foreign_keys = ON;");
        }
        flowContext.putTemporaryData("sqlBuilder", sqlBuilder);
    }

    @Override
    public String name() {
        return "检查外键";
    }
}
